/******************************************************************************/
/* Hardware : ET-BASE PIC32MX                                                 */
/* MCU      : PIC32MX250F128B                                                 */
/* Crystal  : 8MHz                                                            */
/* Run      : External Crystal(8.00MHz)+PLL                                   */
/*          : System Clock FCY = 48MHz(8MHz+PLL : 8MHz / 2 * 24 / 2)          */
/* Compiler : Microchip MPLAB XC32 v1.31                                      */
/******************************************************************************/
// RA0  -> TX1                      // GPIO
// RA1                              // GPIO
// RA2  -> GPIO/CKI                 // GPIO
// RA3  -> GPIO/CKO                 // GPIO
// RA4  -> GPIO/RX1                 // GPIO

// RB0  -> Reserve For : PGED1      // ***DEBUG
// RB1  -> Reserve For : PGEC1      // ***DEBUG
// RB2                              // GPIO
// RB3                              // GPIO
// RB4                              // GPIO
// RB5                              // GPIO
// RB6  -> ***PIC32MX2 Reserve For : +VBUS(5V)
// RB7                              // GPIO

// RB8  -> GPIO/RX2                 // GPIO
// RB9  -> GPIO/TX2                 // GPIO
// RB10 -> GPIO/USB D+              // GPIO
// RB11 -> GPIO/USB D-              // GPIO
// RB12 -> ***PIC32MX2 Reserve For : +VUSB(3V3)
// RB13                             // GPIO
// RB14                             // GPIO
// RB15                             // GPIO

#ifdef __XC32
  #include <xc.h>            /* Defines special funciton registers, CP0 regs  */
#endif

#include <plib.h>           /* Include to use PIC32 peripheral libraries      */

/******************************************************************************/
/* Start of Config:PIC32MX1XX/2XX                                             */
/* define Config Bit Name  in File : "pic32mx250f128b.h"                      */
/* default: "...\Microchip\xc32\v1.31\pic32-libs\include\proc\p32mx250f128b.h"*/
/* define Config Bit Value in File : "32mx250f128b.html"                      */
/* default: "...\Microchip\xc32\v1.31\docs\config_docs\32mx250f128b.html"     */
/******************************************************************************/
// Configuration Bit settings
// Primary Osc = w / PLL (XT+,HS+,EC+PLL)
//             = POSCMOD : HS
//             = FNOSC   : PRIPLL
// SYSCLK      = 8MHz Crystal / FPLLIDIV(2) * FPLLMUL(24) / FPLLODIV(2)
//             = 8.0 MHz      / 2           * 24          / 2
//             = 48.0 MHz
// PBCLK       = SYSCLK(48)   / FPBDIV(1)
//             = 48.0MHz / 1
//             = 48.0 MHz
// WDT OFF

// DEVCFG[0]
#pragma config DEBUG = ON            // Debugger is Enabled
#pragma config JTAGEN = OFF          // JTAG Disabled
#pragma config ICESEL = ICS_PGx1     // ICD Communicate on PGEC1/PGED1
#pragma config PWP = OFF             // Program Flash Write Protect = Disable
#pragma config BWP = OFF             // Boot Flash Write Protect = Disabled
#pragma config CP = OFF              // Code Protect = Disabled

// DEVCFG[1]

// External XTAL + PLL
#pragma config FNOSC = PRIPLL        // Primary Osc w/PLL (XT+,HS+,EC+PLL)
#pragma config POSCMOD = HS          // Primary OSC = HS OSC Mode
#pragma config OSCIOFNC = ON         // CLKO Output on the OSCO = Enabled

// Internal FRC + PLL
//#pragma config FNOSC = FRCPLL        // Fast RC Oscillator + PLL
//#pragma config POSCMOD = OFF         // Primary OSC = Disable
//#pragma config OSCIOFNC = OFF        // CLKO Output on the OSCO = Disabled

#pragma config FSOSCEN = OFF         // Secondary Oscillator = Disabled
#pragma config IESO = OFF            // Internal/External Switch Over=Disabled

#pragma config FPBDIV = DIV_1        // PBCLK = SYSCLK / 1
#pragma config FCKSM = CSDCMD        // Clock Switch Disable, FSCM Disabled
#pragma config WDTPS = PS1048576     // Watchdog Timer Postscaler = 1:1048576
#pragma config WINDIS = OFF          // Watchdog Timer is in Non-Window Mode
#pragma config FWDTEN = OFF          // WDT Disabled (SWDTEN Bit Controls)
#pragma config FWDTWINSZ = WINSZ_75  // Watchdog Timer Window Size is 75%

// DEVCFG[2]
#pragma config FPLLIDIV = DIV_2      // PLL Input Divider = Div 2
#pragma config FPLLMUL = MUL_24      // Fin = PLL x 24
#pragma config UPLLIDIV = DIV_2      // Input USB PLL = Input Clock / 2
#pragma config UPLLEN = OFF          // USB PLL = Disabled and Bypassed
#pragma config FPLLODIV = DIV_2      // Output USB PLL = Output Clock / 2

// DEVCFG[3]
//#pragma config USERID = OFF          // USB USID = Controlled by Port Function
#pragma config PMDL1WAY = OFF        // Peripheral Module = Allow multiple reconfigurations
#pragma config IOL1WAY = OFF         // Peripheral Pin Select = Allow multiple reconfigurations
#pragma config FUSBIDIO = OFF        // USB USID = Controlled by Port Function
#pragma config FVBUSONIO = OFF       // USB VBUS ON = Controlled by Port Function

#define SYS_FREQ (48000000L)         // Run 48.0 MHz
#define LONG_DELAY  (SYS_FREQ/25)

#define	GetSystemClock() 		(48000000ul)
#define	GetPeripheralClock()		(GetSystemClock()/(1 << OSCCONbits.PBDIV))
#define	GetInstructionClock()		(GetSystemClock())

/******************************************************************************/
/* End of Config:PIC32MX1XX/2XX                                               */
/******************************************************************************/
#define OUTPUT         0
#define INPUT          1
#define LED_ON         0
#define LED_OFF        1

/******************************************************************************/
/* Global Variable Declaration                                                */
/******************************************************************************/
void delay(unsigned long delay_count);

/******************************************************************************/
/* Main Program                                                               */
/******************************************************************************/

void main(void)
{
  //============================================================================
  // Configure the device for maximum performance, but do not change the PBDIV clock divisor.
  // Given the options, this function will change the program Flash wait states,
  // RAM wait state and enable prefetch cache, but will not change the PBDIV.
  // The PBDIV value is already set via the pragma FPBDIV option above.
  SYSTEMConfig(SYS_FREQ, SYS_CFG_WAIT_STATES | SYS_CFG_PCACHE);
  //============================================================================

  //Initial All GPIO = Output
  PORTSetPinsDigitalOut(IOPORT_A, BIT_0);
  PORTSetPinsDigitalOut(IOPORT_A, BIT_1);
  PORTSetPinsDigitalOut(IOPORT_A, BIT_2);
  PORTSetPinsDigitalOut(IOPORT_A, BIT_3);
  PORTSetPinsDigitalOut(IOPORT_A, BIT_4);

  PORTSetPinsDigitalOut(IOPORT_B, BIT_0);
  PORTSetPinsDigitalOut(IOPORT_B, BIT_1);
  PORTSetPinsDigitalOut(IOPORT_B, BIT_2);
  PORTSetPinsDigitalOut(IOPORT_B, BIT_3);
  PORTSetPinsDigitalOut(IOPORT_B, BIT_4);
  PORTSetPinsDigitalOut(IOPORT_B, BIT_5);
  PORTSetPinsDigitalOut(IOPORT_B, BIT_6);
  PORTSetPinsDigitalOut(IOPORT_B, BIT_7);
  PORTSetPinsDigitalOut(IOPORT_B, BIT_8);
  PORTSetPinsDigitalOut(IOPORT_B, BIT_9);
  PORTSetPinsDigitalOut(IOPORT_B, BIT_10);
  PORTSetPinsDigitalOut(IOPORT_B, BIT_11);
  PORTSetPinsDigitalOut(IOPORT_B, BIT_12);
  PORTSetPinsDigitalOut(IOPORT_B, BIT_13);
  PORTSetPinsDigitalOut(IOPORT_B, BIT_14);
  PORTSetPinsDigitalOut(IOPORT_B, BIT_15);

  //Start Default Output LED
  PORTSetBits(IOPORT_A, BIT_0);
  PORTSetBits(IOPORT_A, BIT_1);
  PORTSetBits(IOPORT_A, BIT_2);
  PORTSetBits(IOPORT_A, BIT_3);
  PORTSetBits(IOPORT_A, BIT_4);

  PORTSetBits(IOPORT_B, BIT_0);     // Reserve For : PGED1
  PORTSetBits(IOPORT_B, BIT_1);     // Reserve For : PGEC1
  PORTSetBits(IOPORT_B, BIT_2);
  PORTSetBits(IOPORT_B, BIT_3);
  PORTSetBits(IOPORT_B, BIT_4);
  PORTSetBits(IOPORT_B, BIT_5);
  PORTSetBits(IOPORT_B, BIT_6);     // Reserve For : +VBUS
  PORTSetBits(IOPORT_B, BIT_7);
  PORTSetBits(IOPORT_B, BIT_8);
  PORTSetBits(IOPORT_B, BIT_9);
  PORTSetBits(IOPORT_B, BIT_10);
  PORTSetBits(IOPORT_B, BIT_11);
  PORTSetBits(IOPORT_B, BIT_12);    // Reserve For : +VUSB(3V3)
  PORTSetBits(IOPORT_B, BIT_13);
  PORTSetBits(IOPORT_B, BIT_14);
  PORTSetBits(IOPORT_B, BIT_15);

  //Loop Blink LED
  while(1)
  {
    mPORTAToggleBits(BIT_0);        // RA0
    mPORTBToggleBits(BIT_0);        // RB0 -> Reserve For : PGED1
    mPORTBToggleBits(BIT_8);        // RB8
    delay(LONG_DELAY);
    mPORTAToggleBits(BIT_0);        // RA0
    mPORTBToggleBits(BIT_0);        // RB0 -> Reserve For : PGED1
    mPORTBToggleBits(BIT_8);        // RB8
    //
    mPORTAToggleBits(BIT_1);        // RA1
    mPORTBToggleBits(BIT_1);        // RB1 -> Reserve For : PGEC1
    mPORTBToggleBits(BIT_9);        // RB9
    delay(LONG_DELAY);
    mPORTAToggleBits(BIT_1);        // RA1
    mPORTBToggleBits(BIT_1);        // RB1 -> Reserve For : PGEC1
    mPORTBToggleBits(BIT_9);        // RB9
    //
    mPORTAToggleBits(BIT_2);        // RA2
    mPORTBToggleBits(BIT_2);        // RB2
    mPORTBToggleBits(BIT_10);       // RB10
    delay(LONG_DELAY);
    mPORTAToggleBits(BIT_2);        // RA2
    mPORTBToggleBits(BIT_2);        // RB2
    mPORTBToggleBits(BIT_10);       // RB10
    //
    mPORTAToggleBits(BIT_3);        // RA3
    mPORTBToggleBits(BIT_3);        // RB3
    mPORTBToggleBits(BIT_11);       // RB11
    delay(LONG_DELAY);
    mPORTAToggleBits(BIT_3);        // RA3
    mPORTBToggleBits(BIT_3);        // RB3
    mPORTBToggleBits(BIT_11);       // RB11
    //
    mPORTAToggleBits(BIT_4);        // RA4
    mPORTBToggleBits(BIT_4);        // RB4
    mPORTBToggleBits(BIT_12);       // Reserve For : +VUSB(3V3)
    delay(LONG_DELAY);
    mPORTAToggleBits(BIT_4);        // RA4
    mPORTBToggleBits(BIT_4);        // RB4
    mPORTBToggleBits(BIT_12);       // Reserve For : +VUSB(3V3)
    //
    mPORTBToggleBits(BIT_5);        // RB5
    mPORTBToggleBits(BIT_13);       // RB13
    delay(LONG_DELAY);
    mPORTBToggleBits(BIT_5);        // RB5
    mPORTBToggleBits(BIT_13);       // RB13
    //
    mPORTBToggleBits(BIT_6);        // Reserve For : +VBUS
    mPORTBToggleBits(BIT_14);       // RB14
    delay(LONG_DELAY);
    mPORTBToggleBits(BIT_6);        // Reserve For : +VBUS
    mPORTBToggleBits(BIT_14);       // RB14
    //
    mPORTBToggleBits(BIT_7);        // RB7
    mPORTBToggleBits(BIT_15);       // RB15
    delay(LONG_DELAY);
    mPORTBToggleBits(BIT_7);        // RB7
    mPORTBToggleBits(BIT_15);       // RB15
  }
}

/**************************************/
/* Polling Loop Delay 1...delay_count */
/**************************************/
void delay(unsigned long delay_count)
{
  unsigned long i;
  for(i=0; i<delay_count; i++);
}
